/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorCirculationModifier
extends Modifier
implements OnAttackedModifierHook,
DamageDealtModifierHook {
    public boolean isOverworld(Level level) {
        return level.m_46472_().equals((Object)Level.f_46428_);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.DAMAGE_DEALT, ModifierHooks.ON_ATTACKED);
    }

    public void onDamageDealt(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, LivingEntity target, DamageSource source, float amount, boolean isDirectDamage) {
        if (isDirectDamage) {
            LivingEntity attacker = context.getEntity();
            int level = modifier.getLevel();
            if (this.isOverworld(attacker.m_9236_()) && RANDOM.nextFloat() <= 0.2f * (float)level) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60 * level, Math.min(level - 1, 2)));
            } else if (!this.isOverworld(attacker.m_9236_()) && RANDOM.nextFloat() <= 0.2f * (float)level) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60 * level, Math.min(level - 1, 2)));
            }
        }
    }

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity entity = source.m_7639_();
        int level = modifier.getLevel();
        if (isDirectDamage && entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.isOverworld(attacker.m_9236_()) && RANDOM.nextFloat() <= 0.2f * (float)level) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60 * level, Math.min(level - 1, 2)));
            } else if (!this.isOverworld(attacker.m_9236_()) && RANDOM.nextFloat() <= 0.2f * (float)level) {
                attacker.m_20254_(3 * level);
            }
        }
    }
}

